; JFW 3.3 script file for Microsoft Outlook 98
; Copyright 1998, 1999  by Henter-Joyce, Inc.
;3/30/99 by j.c
; 5/15/98. A.G & D.V.

include "outllib.jsh"
include "outllib.jsm"
include "hjconst.jsh"
include "hjglobal.jsh"
use "magOutl.jsb"
globals
	int iIeVersion


Void Function AutoStartEvent ()
var
	string strTemp
let iIeVersion = 0;
let strTemp = GetWindowsSystemDirectory ()
let strTemp = strTemp + "\\shdocvw.dll"
let iIeVersion = GetProgramVersion (strTemp)
if (iIeVersion <= 4) then
	SetJcfOption (OPT_VIRTUAL_PC_CURSOR, off)
EndIf
If (Outlook98FirstTime == 0) then
  let Outlook98Firsttime = 1
If (GetVerbosity () == beginner) then
		    Say(msg44, ot_help) ;"for screen sensitive help Press insert + f1"
		    Say(msg45, ot_help) ;"for JAWS Help Keys or help in dialog boxes Press Insert + H"
		    Say(msg46, ot_help) ;"for a summary of windows short cut keys for Outlook 98 Press insert + W"
EndIf
EndIf
  let OutlookTodayFirstTime = 1
EndFunction

Script ScriptFileName ()
ScriptAndAppNames (msgMSOutlook)
EndScript
Void Function DocumentLoadedEvent ()
var
int nFrames,
int nLinks,
string Buffer
IEUpdate()
if BackForward==1
then SayLine()
let BackForward=0
return
endif
EndFunction

Function SayFocusedWindow ()
var
	int typeOfWindow,
string SWinClass,
int IControlID,
int ISubTCode,
  string SWinName
  let SWinName = GetWindowName (GetRealWindow (GetFocus ()))
  let ISubTCode = GetWindowSubTypeCode (GetFocus ())
  let SWinClass = GetWindowClass (GetFocus ())
  let IControlID = GetControlID (GlobalFocusWindow)
If (GetWindowClass (GlobalFocusWindow) == wcHtmlClass) then
	If (iIeVersion < 5) then
		Say(msg424, ot_message) ;"You can read this message similar to a plain text message"
		say(msg425, ot_message) ;"Use alt + e then the letter e"
	Else
		Say (msg2, OT_HELP); " Edit "
	EndIf
EndIf
If (CaretVisible ()&& ISubTCode == 43 && IControlID == 8224) then
  Say (msg2, ot_control_name)
  Pause ()
SayLine ()  
Return
EndIf
If (! StringContains (SWinName, PersonalFolders)) then
If (OutlookTodayFirstTime > 0) then
  let OutlookTodayFirstTime = 0
Endif
EndIf
If (StringContains (SWinName, PersonalFolders)) then
If (OutlookTodayFirsttime < 1) then
  let OutlookTodayFirstTime = 1
  Say(msg267, ot_message)
  Say(msg268, ot_message)
  Say(msg269, ot_message)
  Say(msg270, ot_message)
  Pause ()
  Return
EndIf
endIf
If (StringContains (SWinName, MeetingDialogName) && IControlID == app_startdate) then
  StopSpeech ()
  Say(msg88, ot_message) ;"Start Date:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
Elif (StringContains (SWinName, MeetingDialogName) && IControlID == app_enddate) then
  StopSpeech ()
  Say(msg89, ot_message) ;"End Date:"
  Say(msg2, ot_control_name) "edit"
  SayWindow (GetFocus (), read_everything)
  Return 
Elif (StringContains (SWinName, MeetingDialogName) && IControlID == message_field) then
  Say(msg271, ot_control_name) ;"Meeting Notes:"
  Say(msg2, ot_control_name) "edit"
  SayLine ()
  Return
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_netmeetingbutton) then
  Say(UpdateNetMeetingButton, ot_control_name)
  Return 
EndIF
If (StringContains (SWinName, AppointmentDialogName) && IControlID == app_start_date) then
StopSpeech ()
  Say(msg88, ot_message) ;"Start Date:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
ElIf (StringContains (SWinName, appointmentDialogName) && IControlID == message_field) then
  say(msg264, ot_message) ;"Appointment Notes"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_netmeetingbutton) then
  Say(UpdateNetMeetingButton, ot_message); "update net meeting button"
  Return 
EndIf
If (StringContains (SWinName, AppointmentDialogName) && IControlID == app_end_date) then
StopSpeech ()
  Say(msg89, ot_message) ;"End Date:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
EndIf
If (StringContains (SWinName, JournalDialogName) && IControlID == j_start_date) then
StopSpeech ()
  Say(msg88, ot_message) ;"Start Date:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
ElIf (StringContains (SWinName, JournalDialogName) && IControlID == message_field) then
  Say(msg265, ot_message) ;"Journal Entry Notes"
EndIf
If (stringContains (SWinName, ContactDialogName) && IControlID == con_phone_descript_one) then
  Say(msg90, ot_control_name) ;"Phone Number Description Button"
  Return
ElIf (stringContains (SWinName, ContactDialogName) && IControlID == con_phone_descript_two) then
  Say(msg90, ot_control_name) ;"Phone Number Description Button"
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_phone_descript_three) then
  Say(msg90, ot_control_name) ;"Phone Number Description Button"
  Return
ElIf (StringContains (SWinName, contactDialogName) && IControlID == con_phone_descript_four) then
  Say(msg90, ot_control_name) ;"Phone Number Description Button"
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_address) then
  Say(msg91, ot_control_name) ;"Enter Multiple Address Button"
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_email) then
  Say(msg92, ot_control_name) ;"Enter Multiple Email Addresses Button"
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == address_field) then
  Say(msg94, ot_control_name) ;"Address..."
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
Return
ElIf (StringContains (SWinName, contactDialogName) && IControlID == email_field) then
  Say(msg95, ot_control_name) ;"Email Address:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
ElIf (stringContains (SWinName, ContactDialogName) && IControlID == con_contact_notes) then
  say(msg96, ot_control_name) ;"Contact Notes:"
  Say(msg2, ot_control_name) ;"edit"
  Return  
ElIf (StringContains (SWinName, ContactDialogName) && ISubTCode == wt_listbox  && iControlID == 4704) then
  Say (msg432,  ot_message)
ElIf (StringContains (SWinName, ContactDialogName) && ISubTCode == wt_listbox  && iControlID == 4513) then
  Say (msg433,  ot_message)
  endIf
If (StringContains (SWinName, TaskDialogName) && IControlID == message_field) then
  Say(msg266, ot_control_name) "Tasks Notes"
ElIf (StringContains (SWinName, taskDialogName) && IControlId == 4108) then
  StopSpeech ()
    Say (msg443, ot_control_name)
  return
ElIf (StringContains (SWinName, taskDialogName) && IControlId == 4102) then
  StopSpeech ()
  Say (msg442, ot_control_name)
  Return
ElIf (StringContains (SWinName, TaskDialogName) && IcontrolID == 4101 && GetControlName () != msg444) then
  StopSpeech ()
  Say (msg442, ot_control_name)
  Return
endIf
if (IControlID == ChangeTo_field) then
	if (GetWindowName (GetParent (GlobalFocusWindow)) == SpellingDialogName) then
		PerformScript ReadMisspelledAndSuggestion ()
		return
	EndIf
EndIf
if ((IControlID == attachments_listbox) &&
	(GetWindowSubTypeCode (globalFocusWindow) == wt_listview)) then
	Say(msg1, ot_message) ; "Attachments"
EndIf
if !DialogActive () then
let typeOfWindow = TypeOfWindow ()
EndIf
SayFocusedObject ()
if (CalendarView (globalFocusWindow) == MonthView) then
	RefreshWindow (globalFocusWindow)
	QuietDelay (1)
	ReadDate (MonthView)
EndIf
EndFunction

Int Function IsNonstandardListBox (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor)
if (GetWindowSubTypeCode (hwnd) != wt_listbox) then
; SayLine ()
	return false
EndIf
if (ColorToRGBString (nTextColor) == ColorToRGBString (nBackgroundColor)) then
	PCCursor ()
	SayLine ()
	return true
EndIf
return false
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, 
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (IsNonStandardListBox (hwnd, buffer, nAttributes, nTextColor, nBackgroundColor)) then
	return
EndIf
if (sFrameName == "") then
	; this text is not associated with a frame
	if (nAttributes& ATTRIB_HIGHLIGHT) then
		SayHighlightedText(hwnd,buffer)
	else
		SayNonHighlightedText(hwnd,buffer)
	endif
else
	; this text is associated with a frame
	if (nEcho == ECHO_NONE) then
		return; frame is being silenced
	endif
	if (nEcho  == ECHO_ALL ||
	   (nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		Say(buffer, ot_buffer)
	endif
endif
EndFunction

Function SayHighlightedText (handle winHandle, string buffer)
var
	int iFocusControl,
	int iFocusWinType,
	int iWinType,
	handle hFocus,
	string sClass
if neverMind then
	return
EndIf
let iWinType = GetWindowSubtypeCode (winHandle)
let hFocus = GetFocus ()
;Added by DB
; to handle some cases of new mail chattering as entering inbox
;
If (GlobalMenuMode == 0) then
	let iFocusControl = GetControliD (hFocus)
	If (!DialogActive ()) ||
	; 'Hide' button
	(iFocusControl == app_location) then
		if (iWinType == WT_LISTBOX) then
			return
		EndIf
	EndIf
EndIf
let sClass = GetWindowClass (hFocus)
; Check against the class of "SUPERGRID" in case type code fails
If (sClass == wcSuperGrid) then
	Return
EndIf
let iFocusWinType = GetWindowSubtypeCode (hFocus)
If (iFocusWinType == WT_EDITCOMBO) then
  Return
EndIf
if GetWindowClass (GetFocus ())==wc_toolbar then
	return
endif
if (winHandle != hFocus) then
	if (GetWindowName (GetParent (hFocus)) == SpellingDialogName) then
		return
	EndIf
EndIf
If (GetWindowName (GetParent (hFocus)) == SpellingDialogName) then
	If (iFocusWinType == WT_EDIT) then
		If (iFocusControl == changeTo_field) then
			If (WinHandle == GetFocus ()) then
				Return
			EndIf
		EndIf
	EndIf
EndIf
SayHighlightedText (WinHandle, buffer)
EndFunction

Function SayNonHighlightedText (handle winHandle, string buffer)
var
	int iWinType,
	int controlId
let iWinType = GetWindowSubTypeCode (WinHandle)
If (iWinType == WT_LISTBOX) then
	Return
EndIf
let controlId = GetControlId (winHandle)
if (ControlId == NotInDictionary_field) then
	if (GetWindowName (GetParent (winHandle)) == SpellingDialogName) then
		PerformScript ReadMisspelledAndSuggestion ()
		return
	EndIf
EndIf
if (controlId == snooze_button) then
	if (buffer == msg460) then ; "Snooze"
		SaveCursor ()
		JawsCursor ()
		MoveToWindow (GetParent (winHandle))
		LeftMouseButton ()
		RestoreCursor ()
		return
	EndIf
EndIf
SayNonHighlightedText (WinHandle, buffer)
EndFunction

HANDLE Function GetHeaderWindow ()
var
	handle winHandle
let winHandle = GetFirstChild (GetAppMainWindow (GetFocus ()))
while (winHandle
	&& (GetWindowClass (winHandle) != AFXWindowClass))
	let winHandle = GetNextWindow (winHandle)
EndWhile
if winHandle then
	let winHandle = GetFirstChild (winHandle)
	while (winHandle
		&& (GetWindowClass (winHandle) != "#32770"))
		let winHandle = GetNextWindow (winHandle)
	EndWhile
EndIf
return winHandle
EndFunction

HANDLE Function GetHeaderControl (int ctrlId)
var
	handle winHandle
let winHandle = GetFirstChild (GetHeaderWindow ())
while (winHandle 
	&& (GetControlId (winHandle) != ctrlId))
	let winHandle = GetNextWindow (winHandle)
EndWhile
return winHandle
EndFunction

Void Function FocusControl (handle winHandle)
var
	int subTypeCode
SaveCursor ()
JawsCursor ()
MoveToWindow (winHandle)
pause ()
LeftMouseButton ()
let subTypeCode = GetWindowSubTypeCode (winHandle) 
if ((subTypeCode == wt_combobox)
	|| (subTypeCode == wt_checkbox)) then
	LeftMouseButton ()
EndIf
RestoreCursor ()
EndFunction

Void Function ReadPrompt (int controlId, int typeOfWindow)
if (typeOfWindow == message_window) then ; this is a message
	if (controlId == from_field) then
		SayWindow (GetHeaderControl (from_prompt), read_everything)
	elif (controlId == sent_field) then
		SayWindow (GetHeaderControl (sent_prompt), read_everything)
	elif (controlId == to_field) then
		if GetHeaderControl (to_prompt) then
			SayWindow (GetHeaderControl (to_prompt), read_everything)
		elif GetHeaderControl (to_button) then
			SayWindow (GetHeaderControl (to_button), read_everything)
		EndIf
	elif (controlId == cc_field) then
		if GetHeaderControl (cc_prompt) then
			SayWindow (GetHeaderControl (cc_prompt), read_everything)
		elif GetHeaderControl (cc_button) then
			SayWindow (GetHeaderControl (cc_button), read_everything)
		EndIf
	elif (controlId == subject_field) then
		SayWindow (GetHeaderControl (subject_prompt), read_everything)
	EndIf
ElIf (typeOfWindow == task_window) then ; this is a task
	if (controlId == TaskSubject_field) then
		SayWindow (GetHeaderControl (TaskSubject_prompt), read_everything)
	elif (controlId == DueDate_field) then
		SayWindow (GetHeaderControl (DueDate_prompt), read_everything)
	elif (controlId == StartDate_field) then
		SayWindow (GetHeaderControl (StartDate_prompt), read_everything)
	elif (controlId == status_combobox) then
		SayWindow (GetHeaderControl (status_prompt), read_everything)
	elif (controlId == priority_combobox) then
		SayWindow (GetHeaderControl (priority_prompt), read_everything)
	elif (controlId == PercentComplete_field) then
		SayWindow (GetHeaderControl (PercentComplete_prompt), read_everything)
	EndIf
ElIf (typeOfWindow == contact_window) then ; this is a contact
	if (controlId == FullName_field) then
		SayWindow (GetHeaderControl (FullName_button), read_everything)
	elif (controlId == JobTitle_field) then
		SayWindow (GetHeaderControl (JobTitle_Prompt), read_everything)
	elif (controlId == company_field) then
		SayWindow (GetHeaderControl (company_Prompt), read_everything)
	elif (controlId == FileAs_field) then
		SayWindow (GetHeaderControl (FileAs_Prompt), read_everything)
	elif (controlId == business_field) then
		SayWindow (GetHeaderControl (business_Prompt), read_everything)
	elif (controlId == home_field) then
		SayWindow (GetHeaderControl (home_Prompt), read_everything)
	elif (controlId == BusinessFax_field) then
		SayWindow (GetHeaderControl (BusinessFax_Prompt), read_everything)
	elif (controlId == mobile_field) then
		SayWindow (GetHeaderControl (mobile_Prompt), read_everything)
	elif (controlId == address_field) then
		SayWindow (GetHeaderControl (address_button), read_everything)
	elif (controlId == email_field) then
		SayWindow (GetHeaderControl (email_prompt), read_everything)
	elif (controlId == web_field) then
		SayWindow (GetHeaderControl (web_prompt), read_everything)
	EndIf
EndIf
EndFunction

Void Function ControlNotFound (int controlId, int typeOfWindow)
if (typeOfWindow == message_window) then ; this is a message
	if (controlId == from_field) then
		Say(msg4, ot_message) "From field not found"
	elif (controlId == sent_field) then
		Say(msg5, ot_message) ;"Sent field not found"
	elif (controlId == to_field) then
		Say(msg6, ot_message) ;"To field not found"
	elif (controlId == cc_field) then
		Say(msg7, ot_message) ;"Cc field not found"
	EndIf
elif (typeOfWindow == task_window) then ; this is a	task
	if (controlId == TaskSubject_field) then
		Say(msg8, ot_message) ;"Subject field not found"
	elif (controlId == DueDate_field) then
		Say(msg9, ot_message) ;"Due Date field not found"
	elif (controlId == StartDate_field) then
		Say(msg10, ot_message) ; "Start date field not found"
	elif (controlId == status_combobox) then
		Say(msg11, ot_message) ;"Status combobox not found"
	elif (controlId == priority_combobox) then
		Say(msg12, ot_message) ;"Priority combobox not found"
	elif (controlId == PercentComplete_field) then
		Say(msg13, ot_message) ;"% complete field not found"
	EndIf
EndIf
EndFunction

Void Function ReadHeaderControl (int controlId, int typeOfWindow)
var
	handle winHandle
let winHandle = GetHeaderControl (controlId)
if winHandle then
	if IsSameScript () then
		FocusControl (winHandle)
		return
	EndIf
	ReadPrompt (controlId, TypeOfWindow)
	if (GetWindowSubTypeCode (winHandle) == wt_checkbox) then
		SayWindowTypeAndText (winHandle)
	else
		SayWindow (winHandle, read_everything)
	EndIf
	if (GetVerbosity () == beginner) then
		Say(msg14, ot_message) ;" Press twice to edit "
	EndIf
else
	ControlNotFound (controlId, typeOfWindow)
EndIf
EndFunction

Script ClickToButton ()
var
	handle winHandle
let winHandle = GetHeaderControl (to_button)
if winHandle then
	FocusControl (winHandle)
else
	Say(msg15, ot_message) ;"To button not found"
EndIf
EndScript

Script ClickCcButton ()
var
	handle winHandle
let winHandle = GetHeaderControl (cc_button)
if winHandle then
	FocusControl (winHandle)
else
	Say(msg16, ot_message) ;"Cc button not found"
EndIf
EndScript

HANDLE Function GetMessageWindow ()
Var
	Handle hTop,
	Handle hFindA,
	Handle hFindAChild,
	Handle hFindB,
	Handle hFindBChild,
	Handle hTarget,
	String hFindBChildClass
Let hTop = GetAppMainWindow (GetFocus ())
If (!hTop) Then
	Say(msg17, ot_message) ; "Message field not found"
Else
	Let hFindA = FindDescendantWindow (hTop, MBTargetID)
EndIf
If (!hFindA) Then
	Say(msg17, ot_message) ; "Message field not found"
Else
	Let hFindAChild = GetFirstChild (hFindA)
EndIf
If (!hFindAChild) Then
	Say(msg17, ot_message) ; "Message field not found"
Else
	Let hFindB = FindDescendantWindow (hFindAChild, MBTargetID1)
EndIf
If (!hFindB) Then
	Say(msg17, ot_message) ; "Message field not found"
Else
	Let hFindBChild = GetFirstChild (hFindB)
EndIf
If (!hFindBChild) Then
	Say(msg17, ot_message) ; "Message field not found"
Else
	Let hFindBChildClass = GetWindowClass (hFindBChild)
	If (hFindBChildClass == AFXWindowClass) Then
		Let hTarget = GetFirstChild (hFindBChild)
	Else
		Let HTarget = hFindBChild
	EndIf
EndIf
Return hTarget
EndFunction

Void Function FocusMessageBodyWindow ()
var
	int iWinType,
	handle winHandle
let winHandle = GetMessageWindow ()
if winHandle then
	JawsCursor ()
	MoveToWindow (WinHandle)
	JawsHome ()
	let WinHandle = GetCurrentWindow ()
	let iWinType = GetWindowSubTypeCode (WinHandle)
	While (iWinType == WT_DIALOG)
		NextLine ()
	let WinHandle = GetCurrentWindow ()
		let iWinType = GetWindowSubTypeCode (WinHandle)
	EndWhile
	If (iWinType == WT_EDIT) then
		FocusControl (winHandle)
		pause ()
		PCCursor ()
		If (StringLength (GetLine ()) > 0) then
			SayLine ()
		EndIf
	Else
		RestrictCursor (on)
		JawsPageUp ()
	JawsHome ()
	RestrictCursor (off)
		RoutePcToJaws ()
		PcCursor ()
	EndIf
	PcCursor ()
else
	Say(msg17, ot_message) ; "Message field not found"
EndIf
EndFunction

Void Function FocusTaskBodyWindow ()
FocusControl (GetHeaderControl (ParentTaskBody_field))
EndFunction

Void Function FocusContactBodyWindow ()
FocusControl (GetHeaderControl (ParentContactBody_field))
EndFunction

Int Function TypeOfWindow ()
var
	string theTitle
let theTitle = GetAppTitle ()
if StringContains (theTitle, " - Message ") then
	return 1
elif StringContains (theTitle, " - Task ") then
	return 2
elif StringContains (theTitle, " - Contact") then
	return 3
EndIf
EndFunction

Script GoToBodyWindow ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
if (typeOfWindow == message_window) then
	FocusMessageBodyWindow ()
ElIf (typeOfWindow == task_window) then
	FocusTaskBodyWindow ()
elif (typeOfWindow == contact_window) then
	FocusContactBodyWindow ()
else
	Say(msg18, ot_message) ;"You must open a message or a task to read its content"
EndIf
EndScript

Script Read1HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
If (StringContains (GetWindowName (GetAppMainWindow (Getfocus ())), msg454)) then
  AutoSayHeader (4512)
  AutoSayHeader (4097)
  return
EndIf 
if (typeOfWindow == message_window) then
	ReadHeaderControl (from_field, typeOfWindow)
elif (typeOfWindow == task_window) then
	ReadHeaderControl (TaskSubject_field, typeOfWindow)
elif (typeOfWindow == contact_window) then
	readHeaderControl (FullName_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read2HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
If (stringContains (GetWindowName (GetAppMainWindow (GetFocus ())), msg454)) then
  AutoSayHeader (4520)
  AutoSayHeader (4105)
  Return
EndIf
if (typeOfWindow == message_window) then
	ReadHeaderControl (sent_field, typeOfWindow)
elif (typeOfWindow == task_window) then
	ReadHeaderControl (DueDate_field, typeOfWindow)
elif (typeOfWindow == contact_window) then
	ReadHeaderControl (JobTitle_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read3HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
If (StringContains (GetWindowName (GetAppMainWindow (GetFocus ())), msg454)) then
  AutoSayHeader (4523)
  AutoSayHeader (4107)
  Return
EndIF
if (typeOfWindow == message_window) then
	ReadHeaderControl (to_field, typeOfWindow)
elif (typeOfWindow == task_window) then
	ReadHeaderControl (StartDate_field, typeOfWindow)
elif (typeOfWindow == contact_window) then
	ReadHeaderControl (company_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read4HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
If (StringContains (GetWindowName (GetAppMainWindow (GetFocus ())), msg454)) then
  AutoSayHeader (4524)
  AutoSayHeader (0)
  Return
EndIf
if (typeOfWindow == message_window) then
	ReadHeaderControl (cc_field, typeOfWindow)
elif (typeOfWindow == task_window) then
	ReadHeaderControl (status_combobox, typeOfWindow)
elif (typeOfWindow == contact_window) then
	ReadHeaderControl (FileAs_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read5HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
If (StringContains (GetWindowName (GetAppMainWindow (GetFocus ())), msg454)) then
  AutoSayHeader (4514)
  AutoSayHeader (4099)
  Return
EndIf
if (typeOfWindow == message_window) then
	ReadHeaderControl (subject_field, typeOfWindow)
elif (typeOfWindow == task_window) then
	ReadHeaderControl (priority_combobox, typeOfWindow)
elif (typeOfWindow == contact_window) then
	ReadHeaderControl (business_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read6HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
If (StringContains (GetWindowName (GetAppMainWindow (GetFocus ())), msg454)) then
  AutoSayHeader (4521)
  AutoSayHeader (4106)
  Return
EndIf
if (typeOfWindow == task_window) then
	ReadHeaderControl (Percentcomplete_field, typeOfWindow)
elif (typeOfWindow == contact_window) then
	ReadHeaderControl (home_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read7HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
if (typeOfWindow == Task_window) then
	ReadHeaderControl (reminder_checkbox, typeOfWindow)
elif (typeOfWindow == contact_window) then
	ReadHeaderControl (BusinessFax_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read8HeaderControl ()	
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
if (typeOfWindow == contact_window) then
	ReadHeaderControl (mobile_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read9HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
if (typeOfWindow == contact_window) then
	ReadHeaderControl (address_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script ClickAddressButton ()
var
	handle winHandle
let winHandle = GetHeaderControl (address_button)
if winHandle then
	FocusControl (winHandle)
else
	Say(msg19, ot_message) ;"Address button not found"
EndIf
EndScript

Script Read10HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
if (typeOfWindow == contact_window) then
	ReadHeaderControl (email_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script Read11HeaderControl ()
var
	int typeOfWindow
let typeOfWindow = TypeOfWindow ()
if (typeOfWindow == contact_window) then
	ReadHeaderControl (web_field, typeOfWindow)
else
	Say(msg_HeaderInfoNotFound, ot_message)
EndIf
EndScript

Script ClickReminderSoundButton ()
var
	int iWinType,
	handle winHandle
let winHandle = GetHeaderControl (ReminderSound_button)
if winHandle then
	let iWinType = GetWindowSubTypeCode (WinHandle)
	If (iWinType != WT_BUTTON) then ; we are using Outlook 2000
		let winHandle = GetHeaderControl (ReminderSound_button2)
	EndIf
	FocusControl (winHandle)
else
	Say(msg20, ot_message) ;"Reminder sound button not found"
EndIf
EndScript

Script ReadMisspelledAndSuggestion ()
var
	handle winHandle
let winHandle = GetParent (GetFocus ())
if (GetWindowName (winHandle) == spellingDialogName) Then
	if (ToggleRestriction ()) then
		ToggleRestriction () 
	EndIf ; if restriction on
	SaveCursor ()
	InvisibleCursor()
	MoveToControl (winHandle, NotInDictionary_field)
	If (GetVerbosity () > beginner) then
		SayWord ()
	Else
		SayLine ()
	EndIf
	SpellString (GetChunk())
	; now see if there are any suggestions
	if MoveToControl (winHandle, suggestions_listbox) then
		if StringContains (GetChunk (), wnNoSuggest) then ; "No Suggestions"
			Say(msg21, ot_message) ; "No suggestions"
		else
			MoveToControl (winHandle, changeTo_field)
			if (GetVerbosity () > beginner) then
				SayWord ()
			else
				SayLine ()
			EndIf ; verbosity
			SpellWord ()
		EndIf ; no suggestions
	EndIf
	let neverMind = true
	delay (10)
	ProcessNewText () ; to try to avoid HighlightedText 
	let neverMind = false
	RestoreCursor ()
Else
	Say(msg22, ot_message)  ; "Not in spell checker"
EndIf
EndScript

Script ClickNoteIcon ()
SaveCursor ()
JawsCursor ()
if FindGraphic (GetParent (GetFocus ()), fsNoteIcon, s_top, s_unrestricted) then
	RightMouseButton ()
	pause ()
	{down arrow}
else
	Say(msg23, ot_message) ;"Note Icon not found"
EndIf
RestoreCursor ()
EndScript

Int Function exp (int n)
var
	int i,
	int thePower
if n then
	let i = 1
	let thePower = 1
	while (i <= n)
		let thePower = thePower * 10
		let i = i+1
	EndWhile
	return thePower
else
	return 1
EndIf
EndFunction

Int Function RightStringToInt (string str)
var
	int i,
	int strLength,
	int theInt,
	string digit,
	int partial
let i = 0
let strLength = StringLength (str)
while (i <= strLength-1)
	let digit = SubString (str, strLength - i, 1)
	if (digit == "0") then
		let partial = 0
	ElIf (digit == "1") then
		let partial = 1
	ElIf (digit == "2") then
		let partial = 2
	ElIf (digit == "3") then
		let partial = 3
	ElIf (digit == "4") then
		let partial = 4
	ElIf (digit == "5") then
		let partial = 5
	ElIf (digit == "6") then
		let partial = 6
	ElIf (digit == "7") then
		let partial = 7
	ElIf (digit == "8") then
		let partial = 8
	ElIf (digit == "9") then
		let partial = 9
	else
		return theInt
	EndIf
	let theInt = theInt + (partial * exp(i))
	let i = i+1
EndWhile
return theInt
EndFunction

Int Function LeftStringToInt (string str)
var
	int i,
	int strLength,
	string digit
let i = 1
let strLength = StringLength (str)
while (i <= strLength)
	let digit = SubString (str, i, 1)
	if ((digit == "0") ||
		(digit == "1") ||
		(digit == "2") ||
		(digit == "3") ||
		(digit == "4") ||
		(digit == "5") ||
		(digit == "6") ||
		(digit == "7") ||
		(digit == "8") ||
		(digit == "9")) then
		return StringToInt (SubString (str, i, strLength - i + 1))
	EndIf
	let i = i + 1
EndWhile
return 0
EndFunction

Function MoveToNearestText ()
var
	int x0,
	int x1,
	int x2,
	int y0,
	int c
if (GetCharacter () != "") then
	return
EndIf
SaveCursor ()
if IsPCCursor () then
	RouteInvisibleToPc ()
ElIf IsJAWSCursor () then
	RouteInvisibleToJAWS ()
EndIf
InvisibleCursor ()
let x0 = GetCursorCol ()
let y0 = GetCursorRow ()
let c = 0
while (((GetCharacter () == "") || 
	StringContains (GetCharacterFont (), "Marlett"))
	&& (GetCursorRow () == y0) 
	&& (c < 20))
	NextCharacter ()
	let c = c+1
EndWhile
if (((GetCharacter () != "") && 
	!StringContains (GetCharacterFont (), "Marlett"))
	&& (GetCursorRow () == y0) ) then
	let x1 = GetCursorCol ()
EndIf
MoveTo (x0, y0)
let c = 0
while (((GetCharacter () == "") || 
	StringContains (GetCharacterFont (), "Marlett"))
	&& (GetCursorRow () == y0) 
	&& (c < 20))
	PriorCharacter ()
	let c = c+1
EndWhile
if (((GetCharacter () != "") && 
	!StringContains (GetCharacterFont (), "Marlett"))
	&& (GetCursorRow () == y0) ) then
	let x2 = GetCursorcol ()
EndIf
if x1 && x2 then
	if ((x1 - x0) < (x0 - x2)) then
		let x0 = x1
	else
		let x0 = x2
	EndIf
ElIf x1 then
	let x0 = x1
ElIf x2 then
	let x0 = x2
EndIf
RestoreCursor ()
MoveTo (x0, y0)
EndFunction

Int Function IsValidDay (string str)
if (1 <= LeftStringToInt (str) <= 31) then
	return true
else
	return false
EndIf
EndFunction

Int Function MonthToNumber (string month)
if (StringContains (month, Jan) == 1)then
	return 1
elif (StringContains (month, Feb) == 1) then
	return 2
elif (StringContains (month, Mar) == 1)then
	return 3
elif (StringContains (month, Apr) ==1) then
	return 4
elif (StringContains (month, May) == 1) then
	return 5
elif (StringContains (month, Jun) == 1) then
	return 6
elif (StringContains (month, Jul) == 1) then
	return 7
elif (StringContains (month, Aug) == 1) then
	return 8
elif (StringContains (month, Sep) == 1) then
	return 9
elif (StringContains (month, Oct) == 1) then
	return 10
elif (StringContains (month, Nov) == 1) then
	return 11
elif (StringContains (month, Dec) == 1) then
	return 12
else
	return 0
EndIf
EndFunction

String Function GetCalendarTitle (int whichWord)
; if whichWord is 0, returns the whole title 
; otherwise returns the whichWord-th word of the title
var
	handle winHandle,
	string calendarTitle,
	int i
let winHandle = GetFirstChild (getAppMainWindow (GetFocus ()))
while (winHandle && 
	(GetControlId (winHandle) != calendar_header) &&
	(GetWindowClass (winHandle) != AFXWindowClass))
	let winHandle = GetNextWindow (winHandle)
EndWhile
if winHandle then
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (winHandle)
	if (GetWord () == "Calendar") then
		if whichWord then
			while (i < whichWord)
				NextWord ()
				let i = i+1
			EndWhile
			if (GetCurrentWindow () == winHandle) then
				return GetWord ()
			EndIf
		else
			let calendarTitle = GetLine ()
			let calendarTitle = SubString (calendarTitle, 9, StringLength (calendarTitle))
			return calendarTitle
		EndIf
	EndIf
EndIf
return ""
EndFunction

String Function GetCurrentMonth ()
var
	string theMonth,
	int c
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPC ()
RestrictCursor (on)
while (!MonthToNumber (GetWord ()) &&
	(c < 100))
	PriorWord ()
	let c = c+1
EndWhile
RestrictCursor (off)
let theMonth = GetWord ()
if MonthToNumber (theMonth) then
	return theMonth
EndIf
EndFunction

Void Function ReadDate (int view)
var
	handle winHandle,
	int x,
	int y,
	string theDay
if (view == MonthView) then

SaveCursor ()
PCCursor ()
let winHandle = GetCurrentWindow ()
let x = GetCursorCol ()
let y = GetCursorRow ()
let theDay = GetField ()
InvisibleCursor ()
MoveToWindow (winHandle)
MoveTo (x, GetCursorRow ())
MoveToNearestText ()
if StringContains (GetWord (), "/") then
	RouteInvisibleToPC ()
	PriorWord ()
	if ((GetCursorRow () == y) 
		&& isValidDay (GetField ())) then
		Say(msg24, ot_message) ;"Saturday"
	else
		Say(msg25, ot_message) ;"Sunday"
	EndIf
else
	SayWord ()
EndIf
PCCursor ()
if StringToInt (theDay) then ; the month is not included in the current day so figure it out
	Say(GetCurrentMonth (), ot_window_name)
EndIf
Say(theDay, ot_window_name)
RestoreCursor ()

EndIf
EndFunction

Script SayDate ()
var
	handle hWnd,
	string sClass
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
If (sClass == wcDayView) then
	If (GetObjectName () == wnDayView) then
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		RestrictCursor (on)
		JawsEnd ()
		PriorWord ()
		If (GetCharacterAttributes () & ATTRIB_GRAPHIC) then
			PriorWord ()
		EndIf
		SayToCursor ()
		RestrictCursor (off)
		RestoreCursor ()
	EndIf
Else 
	Say (msg456, OT_MESSAGE); "Day View not in focus"
EndIf
EndScript

Int Function CalendarView (handle winHandle)
var
	string theClass,
	string firstLine
let theClass = GetWindowClass (winHandle)
if (theClass == AFXWindowClass) then
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (winHandle)
	let firstLine = GetLine ()
	if (StringContains (firstLine, msgMonday) 
		&& StringContains (firstLine, msgTuesday)) then
		return MonthView
	EndIf
EndIf
return 0
EndFunction

Void Function QuietDelay (int time)
let neverMind = true
delay (time)
let neverMind = false
EndFunction

Object Function GetAttachmentsCollection ()
	var
		object OlApp
		let OlApp = GetObject ("Outlook.Application");
		return OlApp.ActiveInspector.CurrentItem.Attachments;
EndFunction

Script AttachmentsList ()
	var
		handle hwnd,
		object OAttachments,
		object null,
		int nAttachments,
		int c
		let OAttachments = GetAttachmentsCollection ()
		let nAttachments = OAttachments.Count
		let hwnd = FindDescendantWindow (GetAppMainWindow (GetFocus ()), attachments_listbox)
if hwnd then 
	; Handle IEServer Windows here,
	; as type code logic fails here by default
	If (GetWindowClass (GetFocus ()) == wcHtmlClass) then
		If (GetWindowClass (hWnd) == wcListView) then
			if !IsWindowObscured (hwnd) then
				FocusControl (hwnd)
				Return
		Else
	If (OAttachments) then
		If (nAttachments > 0) then
			Say(msg419 + IntToString (nAttachments) + msg420, ot_message) ;"There are"
			Say(msg421, ot_message) ;"It is recommmended that you open the file menu and choose save attachments from the menu"
			Say(msg422, ot_message)   ;"To be able to read the attachments in the message"
		else
			Say(msg_NoAttachments, ot_message)
			Return
		EndIf
	EndIf
EndIf
		EndIf
	EndIf
		if (GetWindowSubTypeCode (hwnd) == wt_listview) then
			if !IsWindowObscured (hwnd) then
				FocusControl (hwnd)
				Return
		Else
	If (OAttachments) then
		If (nAttachments > 0) then
			Say(msg419 + IntToString (nAttachments) + msg420, ot_message) ;"There are"
			Say(msg421, ot_message) ;"It is recommmended that you open the file menu and choose save attachments from the menu"
			Say(msg422, ot_message)   ;"To be able to read the attachments in the message"
		else
			Say(msg_NoAttachments, ot_message)
			Return
		EndIf
	EndIf
EndIf
	EndIf
EndIf
Say (msg457, OT_MESSAGE); "Attachments collection could not be found"
		let OAttachments = Null
EndScript

Function ScreenSensitiveHelpForKnownClasses (int nSubTypecode)
If (nSubTypecode == wt_Supergrid) then
  Say (msg447, ot_help)
  Say (msg448, ot_help)
    Say (msg449, ot_help)
  Say (msg450, ot_help)
  Say (msg451, ot_help)
  Say (msg452, ot_help)
  Return
endIf



  ScreenSensitiveHelpForKnownClasses (nSubTypeCode)
EndFunction





Script ScreenSensitiveHelp ()
var
	int iWinType,
  string SWinName,
  int IControlID,
  string SField,
  string SWinClass
  let SWinClass = GetWindowClass (GetCurrentWindow ())
  let SField = GetControlName ()  
let SWinName = GetWindowName (GetRealWindow (GetCurrentWindow ()))
  let IControlID = GetControlID (GetCurrentWindow ())
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
If (StringContains (SWinName, HTmLHeaderString)) then
	If (iIeVersion >= 5) then
		let iWinType = GetWindowSubtypeCode (GetCurrentWindow ())
		If (iWinType > 0) then
			ScreenSensitiveHelpForKnownClasses (iWinType)
			Return
		EndIf
		Say (msg458, OT_HELP); "This is an html message"
		Say (msg459, OT_HELP); "You can read it similar to reading a page in Internet Explorer 5"
		Return
	EndIf
	Say(msg261, ot_help) ;"to read the current screen use Control + Insert + Down Arrow"
	Say(msg262, ot_help) ;"To read the previous screen use Control + Page UP"
	Say(msg263, ot_help) ;"To read the next screen use Control + Page Down"
	Say(msg424, ot_message) ;"You can read this message similar to a plain text message"
	say(msg425, ot_message) ;"Use alt + e then the letter e"
	Say(msg426, ot_message) ;"you can then use the jaws reading commands to read the  message"
	Return
EndIf
If (StringContains (SWinName, AppointmentDialogName) && IControlID == app_subject) then
  Say(msg125, ot_help) ;"this is the subject edit field"
  say(msg126, ot_help) ;"you can enter the subject of the appointment here"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_location) then
  Say(msg129, ot_help) ;"This is the location edit combo box"
  Say(msg130, ot_help) ;"You can type a value or open the list with alt + down arrow"
  Say(msg131, ot_help) ;"Use the arrow keys to move between the items"
  Say(msg132, ot_help) ;"use alt + up arrow or escape to close the list"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_online) then
  Say(msg133, ot_help) ;"this is the on line meeting check box"
  Say(msg134, ot_help) ;"If you are using an application such as Net Meeting for the appointment"
  Say(msg135, ot_help) ;"you should check this box"
  Say(msg136, ot_help) ;"Use the space bar to toggle the check mark on and off"
  Say(msg137, ot_help) ;"use the say word or say line to read the state of the check box"
  say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_startdate) then
  Say(msg138, ot_help) ;"this is the appointment start date edit field"
  say(msg139, ot_help) ;"enter the date such as 1/1/99"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_starttime) then
  Say(msg140, ot_help) ;"this is the appointment start time edit field"
  Say(msg141, ot_help) ;"enter the time such as 1 : 00 pm"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help)  ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_enddate) then
  Say(msg142, ot_help) ;"this is the appointment end date edit field"
  say(msg143, ot_help) ;"enter the date such as 1/1/99"
  say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_endtime) then
  Say(msg144, ot_help)   ;"this is the appointment end time edit field"
Say(msg145, ot_help) ;"enter the time such as 1 : 00 pm"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (IControlID == app_allday) then
  Say(msg146, ot_help) ;"this is the all day event check box"
  Say(msg147, ot_help) ;"if you will be attending this appointment all day then check this box"
  say(msg148, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg149, ot_help) ;"use the say word or say line to read the state of the check box"
  say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && GetControlID (GetParent (GetFocus ())) == app_remindbutton) then
  Say(msg150, ot_help) ;"this is the appointment reminder check box"
  Say(msg151, ot_help) ;"if you would like to be reminded of the appointment check this box"
  Say(msg152, ot_help) ;"use the space bar to toggle the check mark on and offf"
  Say(msg153, ot_help) ;"use say word or say line to read the state of the check box"
  Say(msg128, ot_help)  ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_remindedit) then
  Say(msg154, ot_help) ;"this is the appointment reminder edit field"
  Say(msg155, ot_help) ;"you can enter the number of minutes before the appointment to be reminded"
  say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_remindsound) then
  Say(msg156, ot_help) ;"this is the reminder sound button"
  Say(msg157, ot_help) ;"use this button to set the sound that you wish played for the reminder"
  Say(msg158, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_showtime) then
  Say(msg159, ot_help) ;"this is the appointment show time as combo box"
  Say(msg160, ot_help) ;"use the alt + down arrow to open the list"
  Say(msg161, ot_help) ;"use the arrow keys to move through the list"
  Say(msg162, ot_help) ;"use the alt + up arrow or the escape key to close the list"
  say(msg128, ot_help)   ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_attendee) then
  Say(msg272, ot_help) ;"this is the atendee list box"
  Say(msg273, ot_help) ;"type the names of the people you wish to atend this meeting here"
  Say(msg128, ot_help) ;use tab key to move to the next control
ElIf (Stringcontains (SWinName, AppointmentDialogName) && IControlID == app_inviteothers) then
  Say(msg274, ot_help) ;"this is the invite others button"
  Say(msg275, ot_help) ;"use this button to invite other people to a specific meeting"
  Say(msg128, ot_help) ;use the tab key to move to the next control 
Elif (StringContains (SWinName, AppointmentDialogName) && IControlID == app_optionsbutton) then
  Say(msg276, ot_help) ;"this is the options button"
  Say(msg277, ot_help) ;"use this button to modify the number of hours in a day that is displayed"
  say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_previoustimebutton) then
  Say(msg278, ot_help) ;"this is the select previous time button"
  say(msg279, ot_help) ;"use this button to select the previous time available other than what is displayed"
  Say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_nexttimebutton) then
  Say(msg280, ot_help) ;"this the next time button"
  Say(msg281, ot_help) ;"use this button to select the next avbailable time other than what is displayed"
  Say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_meetingonline) then
  Say(msg282, ot_help) ;"this is the online meetting using check box"
  Say(msg283, ot_help) ;"if you are going to have an on line meeting using net meeting check this box"
    Say(msg284, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg285, ot_help) ;"use the say word or say line to read the status of the check mark"
  Say(msg128, ot_help) ;usethe tab key to move to the next control
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_netmeetingbutton) then
  Say(msg286, ot_help) ;"this is the update net meeting button"
  Say(msg287, ot_help) ;"if you activate this button you will go to the net meeting web site"
  Say(msg288, ot_help) ;"this web site is intended on giving information on the latest"
  Say(msg289, ot_help) ;"of net meeting"
  say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == message_field) then
  Say(msg101, ot_help)  ;"This is the Appointment Notes edit field"
Say(msg163, ot_help)    ;"type specific notes about the appointment"
  Say(msg102, ot_help)   ;"This is the last control in the tab order"
say(msg103, ot_help) ;"Use Shift + tab to review the previous controls"
EndIf
If (StringContains (SWinName, AppointmentDialogName)) then
If (GetVerbosity () == beginner) then
  Say(msg97, ot_help) ;"This is the Create Appointment Dialog" 
  Say(msg98, ot_help) ;"You can use this dialog to enter specific information about the appointment"
  Say(msg99, ot_help) ;"Such as a subject a location and notes specific for the appointment"
  Say(msg100, ot_help) ;"Once all of the information is filled in use Alt + S to Save and Close"
  Return
EndIf
  Return
EndIf
If (StringContains (SWinName, NoteDialogName) && IControlID == 4096) then
  say(msg108, ot_help) ;"This is the Notes edit field"
  Say(MSG109, ot_help) ;"The first line you type becomes the title of the Note"
  Say(MSG110, ot_help) ;"To save and close the note use the Escape key"
	Return
endIf
If (StringContains (SWinName, MeetingDialogName) && IControlID == app_subject) then
  Say(msg125, ot_help) ;"this is the subject edit field"
  say(msg290, ot_help) ;"you can enter the subject of the Meeting here"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_location) then
  Say(msg129, ot_help) ;"This is the location edit combo box"
  Say(msg130, ot_help) ;"You can type a value or open the list with alt + down arrow"
  Say(msg131, ot_help) ;"Use the arrow keys to move between the items"
  Say(msg132, ot_help) ;"use alt + up arrow or escape to close the list"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_online) then
  Say(msg133, ot_help) ;"this is the on line meeting check box"
  Say(msg134, ot_help) ;"If you are using an application such as Net Meeting for the Meeting"
  Say(msg135, ot_help) ;"you should check this box"
  Say(msg136, ot_help) ;"Use the space bar to toggle the check mark on and off"
  Say(msg137, ot_help) ;"use the say word or say line to read the state of the check box"
  say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_startdate) then
  Say(msg291, ot_help) ;"this is the Meeting start date edit field"
  say(msg139, ot_help) ;"enter the date such as 1/1/99"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_starttime) then
  Say(msg292, ot_help) ;"this is the Meeting start time edit field"
  Say(msg141, ot_help) ;"enter the time such as 1 : 00 pm"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help)  ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_enddate) then
  Say(msg293, ot_help) ;"this is the Meeting end date edit field"
  say(msg143, ot_help) ;"enter the date such as 1/1/99"
  say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_endtime) then
  Say(msg294, ot_help)   ;"this is the Meeting end time edit field"
Say(msg145, ot_help) ;"enter the time such as 1 : 00 pm"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (IControlID == app_allday) then
  Say(msg146, ot_help) ;"this is the all day event check box"
  Say(msg147, ot_help) ;"if you will be attending this Meeting all day then check this box"
  say(msg148, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg149, ot_help) ;"use the say word or say line to read the state of the check box"
  say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && GetControlID (GetParent (GetFocus ())) == app_remindbutton) then
  Say(msg295, ot_help) ;"this is the Meeting reminder check box"
  Say(msg151, ot_help) ;"if you would like to be reminded of the Meeting check this box"
  Say(msg152, ot_help) ;"use the space bar to toggle the check mark on and offf"
  Say(msg153, ot_help) ;"use say word or say line to read the state of the check box"
  Say(msg128, ot_help)  ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_remindedit) then
  Say(msg296, ot_help) ;"this is the Meeting reminder edit field"
  Say(msg155, ot_help) ;"you can enter the number of minutes before the Meeting to be reminded"
  say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_remindsound
&& SField == msg297) then
  Say(msg156, ot_help) ;"this is the reminder sound button"
  Say(msg157, ot_help) ;"use this button to set the sound that you wish played for the reminder"
  Say(msg158, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_showtime) then
  Say(msg298, ot_help) ;"this is the Meeting show time as combo box"
  Say(msg160, ot_help) ;"use the alt + down arrow to open the list"
  Say(msg161, ot_help) ;"use the arrow keys to move through the list"
  Say(msg162, ot_help) ;"use the alt + up arrow or the escape key to close the list"
  say(msg128, ot_help)   ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_attendee) then
  Say(msg299, ot_help) ;("this is the atendee list box"
  Say(msg300, ot_help) ;"type the names of the people you wish to atend this meeting here"
  Say(msg128, ot_help) ;use tab key to move to the next control
ElIf (Stringcontains (SWinName, MeetingDialogName) && IControlID == app_inviteothers) then
  Say(msg301, ot_help) ;"this is the invite others button"
  Say(msg302, ot_help) ;"use this button to invite other people to a specific meeting"
  Say(msg128, ot_help) ;use the tab key to move to the next control 
Elif (StringContains (SWinName, MeetingDialogName) && IControlID == app_optionsbutton) then
  Say(msg303, ot_help) ;"this is the options button"
  Say(msg304, ot_help) ;"use this button to modify the number of hours in a day that is displayed"
  say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_previoustimebutton) then
  Say(msg305, ot_help) ;"this is the select previous time button"
  say(msg306, ot_help) ;"use this button to select the previous time available other than what is displayed"
  Say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_nexttimebutton) then
  Say(msg307, ot_help) ;"this the next time button"
  Say(msg308, ot_help) ;"use this button to select the next avbailable time other than what is displayed"
  Say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_meetingonline) then
  Say(msg309, ot_help) ;"this is the online meetting using check box"
  Say(msg310, ot_help) ;"if you are going to have an on line meeting using net meeting check this box"
    Say(msg311, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg312, ot_help) ;"use the say word or say line to read the status of the check mark"
  Say(msg128, ot_help) ;usethe tab key to move to the next control
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_netmeetingbutton) then
  Say(msg313, ot_help) ;"this is the update net meeting button"
  Say(msg314, ot_help) ;"if you activate this button you will go to the net meeting web site"
  Say(msg315, ot_help) ;"this web site is intended on giving information on the latest"
  Say(msg316, ot_help) ;"of net meeting"
  say(msg128, ot_help) ;use the tab key to move to the next control
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == message_field) then
  Say(msg317, ot_help)  ;"This is the Meeting Notes edit field"
Say(msg318, ot_help)    ;"type specific notes about the Meeting"
  Say(msg102, ot_help)   ;"This is the last control in the tab order"
say(msg103, ot_help) ;"Use Shift + tab to review the previous controls"
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_ToField) then
  Say(msg319, ot_help) ;"this is the to... edit field"
  Say(msg320, ot_help) ;"use this field to type the name of the person that the meeting request is to go to"
  say(msg127, ot_help)
  Say(msg128, ot_help)
EndIf
If (StringContains (SWinName, MeetingDialogName) && IControlID != 4704) then
If (GetVerbosity () == beginner) then
  Say(msg321, ot_help) ;"This is the Create Meeting Dialog" 
  Say(msg322, ot_help) ;"You can use this dialog to enter specific information about the Meeting"
  Say(msg99, ot_help) ;"Such as a subject a location and notes specific for the Meeting"
  Say(msg323, ot_help) ;"Once all of the information is filled in use Alt + S to Save and Close"
  Return
EndIf
  Return
EndIf
If (StringContains (SWinName, ContactDialogName) && IControlID == fullName_field && SField == msg93) then
  Say(msg164, ot_help) ;"this is the contact full name edit field"
  Say(msg165, ot_help) ;"type the contacts first and last name in this field"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (SWinClass == wc_listboxes && IControlID == 109) then
  Say (msg437, ot_help)
  Say (msg438, ot_help)
  Say (
msg439, ot_help)
  Say (msg440, ot_help)
  Say (msg441, ot_help)
  Return 
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == fullName_field) then
  Say (msg430, ot_help)
  Say (msg431, ot_help)
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == JobTitle_field
&& SField == msg324) then
  Say(msg166, ot_help) ;"this is the contact job title edit field"
  say(msg167, ot_help) ;"type the contacts job title in this field such as president"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == company_field) then
  Say(msg168, ot_help) ;"this is the contact company edit field"
  Say(msg169, ot_help) ;"type the contacts company name in this field"
  say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == FileAs_field) then
  Say(msg170, ot_help) ;"this is the file as edit combo box"
  Say(msg171, ot_help) ;"use this edit combo box to choose the way the name of the contact will be shown"
  Say(msg172, ot_help) ;"type in a value or open a list of items with alt + down arrow"
  Say(msg173, ot_help) ;"use the arrow keys to move through the items"
  Say(msg174, ot_help) ;"use the alt + up arrow or the escape key to close the list of items"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && 
IControlID == con_phone_descript_one || IControlID == con_phone_descript_two 
|| IControlID == con_phone_descript_three || IControlID == con_phone_descript_four)  then
  Say(msg119, ot_help) ;"This is the Phone Number Description Button"
  Say(msg120, ot_help) ;"Use this button to add a description to the phone number you enter in theaappropriate field"
  Say(msg175, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_address
&& SField == msg325) then
  Say(msg121, ot_help) ;"This is the Address Button"
  Say(msg122, ot_help) ;"You can enter up to 3 addresses for a contact"
  Say(msg175, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
elIf (StringContains (SWinName, ContactDialogName) && IControlID == con_email) then
  Say(msg123, ot_help) ;"This is the Email Address Button"
  Say(msg124, ot_help) ;"You can use this button to enter up to 3 email addresses for a contact"
  Say(msg175, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
 ElIf (StringContains (SWinName, ContactDialogName) && IControlID == business_field
&& SField == msg326) then
  Say(msg176, ot_help) ;"this is the contact business telephone number edit field"
  Say(msg177, ot_help) ;"use this field to enter the contacts business telephone number"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == business_field) then
  Say(msg327, ot_help) ;"this is the office edit field"
  Say(msg328, ot_help) ;"use this field to type in the office name or telephone number"
  Say(msg127, ot_help)
  say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == home_field
&& SField == msg329) then
  say(msg178, ot_help) ;"this is the contact home telephone number edit field"
  Say(msg179, ot_help) ;"enter the contacts home telephone number in this field"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text")
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
elIf (StringContains (SWinName, contactDialogName) && IControlID == home_field) then
  Say(msg330, ot_help) ;"this is the assistants name edit field"
  Say(msg331, ot_help) ;"use this field to enter the name of an assistant for a contact"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == app_profession) then
  Say(msg332, ot_help) ;"this is teh profession edit field"
  Say(msg333, ot_help) ;"use this field to enter information about the contacts profession or a professional orginization"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == app_nickname) then
  Say(msg334, ot_help) ;"this is the nick name edit field"
  Say(msg335, ot_help) ;"use this field to enter a nick name for a contact"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == BusinessFax_Field
&& SField == msg336) then  
  Say(msg180, ot_help) ;"this is the contact business fax telephone number edit field"
  say(msg181, ot_help) ;"enter the contacts business fax telephone number in this field"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == BusinessFax_Field) then
  Say(msg337, ot_help) ;"this is the spouse's name edit field"
  Say(msg338, ot_help) ;"enter the name of the contacts spouse in this field"
    Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_directoryserver) then
  Say(msg339, ot_help) ;"this is the directory server edit field"
  Say(msg340, ot_help) ;"enter the name of the server for use with net meeting"
    Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_emailalias) then
  Say(msg341, ot_help) ;"this is the email alias edit field"
  Say(msg342, ot_help) ;"enter an email alias in this field"
    Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_callnow
&& SField == msg343) then
  Say(msg344, ot_help) ;"this is the call now button"
  Say(msg345, ot_help) ;"avtivate this button to begin a net meeting session"
    Say(msg346, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_callnow) then
  Say(msg347, ot_help) ;"this is the import button"
  Say(msg348, ot_help) ;"use this button to import a certificate"
  Say(msg349, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_urladdress) then
  Say(msg350, ot_help) ;"this is the u r l address edit field"
  Say(msg351, ot_help) ;"enter a specific u r l for a net meeting"
    Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == mobile_field
&& SField == msg352) then
  Say(msg182, ot_help) ;"this is the contact mobile telephone number edit field"
  Say(msg183, ot_help) ;"enter the contacts mobile telephone number in this field"
  Say(msg184, ot_help) ;"such as a cellular telephone number"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == mobile_field) then
  Say(msg353, ot_help) ;"this is the birthday edit field"
  Say(msg354, ot_help) ;"enter the contacts birthday in this field"
    Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_newjournalentry
&& SField == msg355) then
  Say(msg356, ot_help) ;"this is the new journal entry button"
  Say(msg357, ot_help) ;"use this button to make a new journal entry for the contact"
  Say(msg358, ot_help) ;("use the space bar to activate this button"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_newjournalentry) then
  Say(msg359, ot_help) ;"this is the new button"
  Say(msg360, ot_help) ;"use this button to define new fields for use"
  Say(msg361, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) 
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_automaticallyrecord) then
		Say(msg362, ot_help) ;"this is the automatically record journal entry check box"
  Say(msg363, ot_help) ;"check this box if you want to automatically record a journal entry for the contact"
  Say(msg364, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg365, ot_help) ;"use say word or say line to read the state of the check mark"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_showentries
&& SField == msg366) then
  Say(msg367, ot_help) ;"this is the show combo box"
  Say(msg368, ot_help) ;" use this combo box to display the types of entries for the journal"
  Say(msg369, ot_help) ;"you can type in a value or use the alt + down arrow to open a list of choices"
  Say(msg370, ot_help) ;"use the escape key or the alt + up arrow to close the list"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_showentries) then
  Say(msg371, ot_help) ;"this is the select from combo box"
  Say(msg372, ot_help) ;"you can select the fields that you wish to have displayed"
  Say(msg373, ot_help) ;"type in a value or open a list of options with alt + down arrow"
  Say(msg374, ot_help) ;"you can navigate the list of options with the arrow keys"
  Say(msg375, ot_help) ;"close the list with the escape key or the alt + up arrow"
  Say(msg128, ot_help)
ElIF (StringContains (SWinName, ContactDialogName) && IControlID == con_fieldlist) then
  Say(msg376, ot_help) ;"this is a list of the new fields"
  Say(msg377, ot_help) ;"you can use the arrow keys to navigate the list of items"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == address_button) then
  Say(msg185, ot_help) ;"this is the contact address button"
  Say(msg186, ot_help) ;"press enter to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == address_field) then
  Say(msg187, ot_help) ;"this is the contact address edit field"
  Say(msg188, ot_help) ;"enter the contacts address in this field"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == address_checkbox
&& SField == msg378) then
  Say(msg189, ot_help) ;"this is the contact mailng address check box"
  Say(msg190, ot_help) ;"if the entered address is the mailing address check this box"
  Say(msg191, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg192, ot_help) ;"use say word or say line to read the state of the check box"
  Say(msg128, ot_help)   ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == address_checkbox) then
  Say(msg379, ot_help) ;"this is the auto pre view check box"
  Say(msg380, ot_help) ;"use this check box if you wish to auto pre view the entries for the contact"
  Say(msg381, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg382, ot_help) ;"use say word or say line to read the state of the check mark"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == email_field) then
  Say(msg193, ot_help) ;"this is the contact email address edit field"
  Say(msg194, ot_help) ;"enter the contacts email address in this field"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == addressbook_button) then
  Say(msg195, ot_help) ;"this is the address book button"
  Say(msg196, ot_help) ;"use the address book to edit or add email addresses to the address book"
  Say(msg197, ot_help) ;"use the enter key to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == plaintext_checkbox) then
  say(msg198, ot_help) ;"this is the contact send mail in plain text format check box"
  Say(msg199, ot_help) ;"use this control to send all messages in plain text format"
  Say(msg200, ot_help) ;"use the space bar to toggle the check mark on and off"
  say(msg201, ot_help) ;"use say word or say line to read the state of the check box"
  say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == web_field) then
  Say(msg202, ot_help) ;"this is the contact web page edit field"
  Say(msg203, ot_help) ;"enter the contacts web site home page in this field"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
   ElIf (StringContains (SWinName, ContactDialogName) && IControlID == message_field) then
      Say(msg107, ot_help)  ;"This is the Contact Notes edit field"
  Say(msg204, ot_help) ;"enter any other specific information about a contact in this field"
  Say(msg102, ot_help)   ;"This is the last control in the tab order"
say(msg103, ot_help) ;"Use Shift + tab to review the previous controls"
EndIf
If (StringContains (SWinName, ContactDialogName) && iControlID != 4704) then
If (GetVerbosity () == beginner) then
  Say(msg104, ot_help) ;"This is the Create Contact Dialog"
  Say(msg105, ot_help) ;"You can use this dialog to enter specific information about the Contact"
  Say(msg106, ot_help) ;"Such as Contact Name and Phone Numbers or Email Addresses also Notes specific to a Contact"
  Say(msg100, ot_help) ;"Once all of the information is filled in use Alt + S to Save and Close"
  Return
endIf
  Return
EndIf
If (StringContains (SWinName, TaskDialogName) && IControlID ==TaskSubject_field
&& SField == msg386) then
  Say(msg205, ot_help) ;"this is the Task subject edit field"
  Say(msg206, ot_help) ;"enter the subject or purpose for this task in this field"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == DueDate_field
&& SField == msg387) then
  Say(msg207, ot_help) ;"this is the task due date edit field"
  Say(msg208, ot_help) ;"enter the date that the task is due in this field"
  say(msg209, ot_help) ;"such as 1/1/99"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
 ElIf (StringContains (SWinName, TaskDialogName) && IControlID == StartDate_field
&& SField == msg388) then
  Say(msg210, ot_help) ;"this is the start date edit field"
  Say(msg211, ot_help) ;"enter the date the task should be started in this field"
  Say(msg212, ot_help) ;"such as1/1/99"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == status_combobox) then
  Say(msg213, ot_help) ;"this is the task status combo box"
  Say(msg214, ot_help) ;"use this combo box to display a status that the task is in such as in progress"
  Say(msg215, ot_help) ;"use the alt + down arrow to open the list of items"
  Say(msg216, ot_help) ;"use the arrow keys to move through the items in the list"
  Say(msg217, ot_help) ;"use the alt + up arrow or the escape key to close the list of items"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == priority_combobox) then
    Say(msg218, ot_help) ;"this is the task priority combo box"
  Say(msg219, ot_help) ;"use this combo box to assign a priority to a task"
  Say(msg220, ot_help) ;"use the alt + down arrow to open a list of items"
  Say(msg221, ot_help) ;"use the arrow keys to move through the list of items"
  Say(msg222, ot_help) ;"use the alt + up arrow or the escape key to close the list of items"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == PercentComplete_field) then
  Say(msg223, ot_help) ;"this is the task percent complete edit field"
  Say(msg224, ot_help) ;"use this field to keep track of how much of the task has been completed"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == reminder_checkbox) then
  Say(msg225, ot_help) ;"this is the reminder check box"
  Say(msg226, ot_help) ;"use this check box to set a reminder for the task"
  Say(msg227, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg228, ot_help) ;"use the say word or say line to read the state of the check box"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == ReminderSound_button) then
  Say(msg229, ot_message) ;"this is the reminder sound button"
  Say(msg230, ot_help) ;"use this button to set the sound that you wish to be played when you are reminded of the task"
  Say(msg231, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == message_field) then
    Say(MSG118, ot_help)  ;"This is the Tasks Notes edit field"
  Say(msg232, ot_help) ;"use this edit field for entering specific notes about the task"
  Say(msg102, ot_help)   ;"This is the last control in the tab order"
say(msg103, ot_help) ;"Use Shift + tab to review the previous controls"
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_datecompleted) then 
  Say(msg389, ot_help) ;"this is the date completed edit field"
  Say(msg390, ot_help) ;"enter the date that the task is completed in this field"
  Say(msg391, ot_help) ;"such as 1/01/99"
  Say(msg127, ot_help) ;use the left and right arrow keys to move through the entered text 
  Say(msg128, ot_help) ;use the tab key to move to the next control
	elIf (StringContains (SWinName, TaskDialogName) && IControlID == t_totalwork) then
  Say(msg392, ot_help) ;"this is the total work edit field"
  Say(msg393, ot_help) ;"use this field to enter the total hours that it took to complete the task"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
  ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_actualwork
&& SField == msg394) then
  Say(msg395, ot_help) ;"this is the actual work edit field"
  Say(msg396, ot_help) ;"use this field to enter the actual hours worked on the task"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_mileage) then
  Say(msg397, ot_help) ;"this is the mileage edit field"
  Say(msg398, ot_help) ;"enter the total miles traveled while performing this task"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_billinginformation) then
  Say(msg399, ot_help) ;"this is the billing information edit field"
  Say(msg400, ot_help) ;"enter any billing information for this task in this field"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_contacts) then
  Say(msg401, ot_help) ;"this is the contacts edit field"
  Say(msg402, ot_help) ;"enter any contact name associated with thistask"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_companies) then
  Say(msg403, ot_help) ;"this is the companies edit field"
  Say(msg404, ot_help) ;"enter any company name that is associated with the task"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_updatelist) then
  Say(msg405, ot_help) ;"this is the update list edit field"
  Say(msg406, ot_help) ;"enter the names of the people that should get a copy of the task"
  Say(msg407, ot_help) ;"each time the task list is updated in this field"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
elIf (StringContains (SWinName, TaskDialogName) && IControlID == 4096)then
  Say(msg408, ot_help);"this is the to edit field"
  Say(msg409, ot_help) ;"use this field to type in the name of the person that the task will be sent to"
  Say(msg127, ot_help)
  Say(msg128, ot_help)
elIf (StringContains (SWinName, TaskDialogName) && IControlID == t_taskcopy) then
  Say(msg410, ot_help) ;"this is the keep a copy of the task check box"
  Say(msg411, ot_help) ;"use this check box to keep a current copy of the task"
  Say(msg412, ot_help) ;"in your task list"
  Say(msg413, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg414, ot_help) ;"use the say Word or say line to read the status of teh check mark"
  Say(msg128, ot_help)
ElIf (StringContains (SWinName, TaskDialogName) && IControlID == t_statusreport) then
  Say(msg415, ot_help) ;"this is the status report request check box"
  Say(msg416, ot_help) ;"use this check box if you wish to have a status report on the task"
    Say(msg417, ot_help) ;"use the space bar to toggle the check mark on and off"
  Say(msg418, ot_help) ;"use the say Word or say line to read the status of teh check mark"
  Say(msg128, ot_help)
EndIf
If (StringContains (SWinName, TaskDialogName) && IControlID != 4704) then
If (GetVerbosity () == beginner) then 
  Say(MSG115, ot_help) ;"This is the Create Tasks Dialog"
  Say(MSG116, ot_help) ;"You can use this dialog to enter specific information about the Tasks"
  Say(MSG117, ot_help) ;"Such as a subject a Status and notes specific for the Tasks"
  Say(msg100, ot_help) ;"Once all of the information is filled in use Alt + S to Save and Close"
  Return
EndIf
  Return
EndIf
If (StringContains (SWinName, JournalDialogName) && IControlID == j_subject) then
  Say(msg233, ot_help) ;"this is the subject edit field for the journal"
  Say(msg234, ot_help) ;"use this edit field for entering the subject or the ppurpose of the entry"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_entrytype) then
  say(msg235, ot_help) ;" this is the journal entry type combo box"
  Say(msg236, ot_help) ;"use this combo box to choose an entry type such as phone call"
  say(msg237, ot_help) ;"use the alt + down arrow to open a list of items"
  Say(msg238, ot_help) ;"use the arrow keys to move through the items in the list"
  Say(msg239, ot_help) ;"use the alt + up arrow or the escape key to close the list of items"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
 ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_contact) then
  say(msg240, ot_help) ;"this isthe the journal contact edit field"
  Say(msg241, ot_help) ;"enter the name of the contact for the journal entry in this field"
  Say(msg127, ot_help);"Use the left and right arrow keys to move through the entered text"
  say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_addressbook) then
ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_company) then
  Say(msg242, ot_help) ;"this is the journal company edit field"
  Say(msg243, ot_help) ;"use this edit field to enter a company name for the contact for this journal entry"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_startdate) then
  Say(msg244, ot_help) ;"this is the start date edit field for the journal"
  Say(msg245, ot_help) ;"use this field to enter a start date for the journal entry"
  Say(msg246, ot_help) ;"such as 1/1/99"
  say(msg247, ot_help) ;"Outlook will usually put the date in for you"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_starttime) then
  Say(msg248, ot_help) ;"this is the start time edit field for the journal entry"
  Say(msg249, ot_help) ;"use this edit field to enter a start time"
  Say(msg250, ot_help) ;"Outlook will usually put the time in for you"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_duration) then
  Say(msg251, ot_help) ;"this is the duration edit field for the journal entry"
  Say(msg252, ot_help) ;"this information can be entered manually or when you start the timer the journal will fill it in for you"
  Say(msg127, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
 ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_starttimer) then
  Say(msg253, ot_help) ;"this is the start timer button for the journal entry"
  Say(msg254, ot_help) ;"the time will be displayed in the duration edit field"
  Say(msg255, ot_help) ;"when this button is pressed it then becomes the pause timer button"
  Say(msg256, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
 ElIf (StringContains (SWinName, JournalDialogName) && IControlID == j_pausetimer) then
  Say(msg257, ot_help) ;"this is the pause timer button for the journal entry"
  Say(msg258, ot_help) ;"when this button is pressed it then becomes the start timer button"
  Say(msg259, ot_help) ;"the result of the timer is displayed in the duration edit field"
  Say(msg260, ot_help) ;"use the space bar to activate this button"
  Say(msg128, ot_help) ;"use the tab key to move to the next control"
 ElIf (StringContains (SWinName, JournalDialogName) && IControlID == message_field) then
    Say(MSG114, ot_help)  ;"This is the Journal Entry Notes edit field"
  Say(msg102, ot_help)   ;"This is the last control in the tab order"
say(msg103, ot_help) ;"Use Shift + tab to review the previous controls"
  EndIf
If (StringContains (SWinName, JournalDialogName) && SWinClass != wt_listbox) then
If (GetVerbosity () == beginner) then
  Say(MSG111, ot_help) ;"This is the Create Journal Entry Dialog"
  Say(MSG112, ot_help) ;"You can use this dialog to enter specific information about the Journal Entry"
  Say(MSG113, ot_help) ;"Such as a subject a Contact name and Notes specific for the Journal entry"
  Say(msg100, ot_help) ;"Once all of the information is filled in use Alt + S to Save and Close"
  Return
EndIf
  Return
EndIf
If (GetWindowClass (GetFocus ()) == "Supergrid" 
&& StringContains (GetWindowName (GetAppMainWindow (GetFocus ())), "Contacts")
|| StringContains (GetWindowName (GetAppMainWindow (getFocus ())), "Calendar")
|| StringContains (GetWindowName (GetAppMainWindow (GetFocus ())), "Tasks")) then
    ScreenSensitiveHelpForKnownClasses (wt_Supergrid)
  Return
EndIf
  PerformScript ScreenSensitiveHelp()
EndScript

Script SayNextCharacter ()
var
	int view
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		NextCharacter ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript SayNextCharacter ()
EndScript

Script SayPriorCharacter ()
var
	int view
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		PriorCharacter ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript SayPriorCharacter ()
EndScript

Script SayNextLine ()
var
	int iWinType,
	int iVerbosity,
	int view,
	handle hFocus,
  string SWinName,
  int IControlID
let hFocus = GetFocus ()
let SWinName = GetWindowName (GetRealWindow (hFocus))
let IControlID = GetControlID (hFocus)
let iWinType = GetWindowSubTypeCode (hFocus)
let iVerbosity = GetVerbosity ()
If (iWinType == wt_listbox) then    
	If (IsPcCursor ()) then
		NextLine ()
		If (DialogActive ()) then
			SayLine ()
			Return
		EndIf
		Pause ()
		If (iVerbosity > 0) then
			SayFromCursor ()
		Else
			PerformScript SayLine ()
		EndIf
		Return
	EndIf
EndIf
If (StringContains (SWinName, CalendarTitleList) && IControlID == cal_list) then
  NextLine ()
  SayLine ()
  Return
EndIF
If (StringContains (SWinName, TaskList) && IControlID == cal_list) then
  NextLine ()
  SayLine ()
  Return
EndIF
If (StringContains (SWinName, ContactsList) && IControlID == cal_list) then
  NextLine ()
  SayLine ()
  Return
EndIF
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		NextLine ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript SayNextLine ()
EndScript

Script SayPriorLine ()
var
	int iWinType,
	int iVerbosity,
	int view,
	handle hFocus,
  string SWinName,
  int IControlID
let hFocus = GetFocus ()
let SWinName = GetWindowName (GetRealWindow (hFocus))
let IControlID = GetControlID (hFocus)
let iWinType = GetWindowSubTypeCode (hFocus)
let iVerbosity = GetVerbosity ()
If (iWinType == wt_listbox) then    
	If (IsPcCursor ()) then
		PriorLine ()
		If (DialogActive ()) then
			SayLine ()
			Return
		EndIf
		Pause ()
		If (iVerbosity > 0) then
			SayFromCursor ()
		Else
			PerformScript SayLine ()
		EndIf
		Return
	EndIf
EndIf
If (StringContains (SWinName, CalendarTitleList) && IControlID == cal_list) then
  PriorLine ()
  SayLine ()
  Return
EndIF
If (StringContains (SWinName, TaskList) && IControlID == cal_list) then
  PriorLine ()
  SayLine ()
  Return
EndIF
If (StringContains (SWinName, ContactsList) && IControlID == cal_list) then
  PriorLine ()
  SayLine ()
  Return
EndIF
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		PriorLine ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript SayPriorLine ()
EndScript

Script JawsHome ()
var
	int iVerbosity,
	int view,
	string sClass
If (! IsPcCursor ()) then
	PerformScript JawsHome ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript JawsHome ()
	Return
EndIf
let sClass = GetWindowClass (GetFocus ())
If (sClass == wcListBox) then
	PerformScript JawsHome ()
	Return
EndIf
let iVerbosity = GetVerbosity ()
If (GetWindowSubTypeCode (GetFocus ()) == wt_listbox) then
	{Home}
	If (DialogActive ()) then
		SayLine ()
		Return
	EndIf
	Pause ()
	If (iVerbosity > 0) then
		SayFromCursor ()
	Else
		SayLine ()
	EndIf
	Return
EndIf 
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		JawsHome ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript JawsHome ()
EndScript

Script JawsEnd ()
var
	int iVerbosity,
	int view,
	string sClass
If (! IsPcCursor ()) then
	PerformScript JawsEnd ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript JawsEnd ()
	Return
EndIf
let sClass = GetWindowClass (GetFocus ())
If (sClass == wcListBox) then
	PerformScript JawsEnd ()
	Return
EndIf
let iVerbosity = GetVerbosity ()
If (GetWindowSubTypeCode (GetFocus ()) == wt_listbox) then
	{End}
	If (DialogActive ()) then
		SayLine ()
		Return
	EndIf
	Pause ()
	If (iVerbosity > 0) then
		SayFromCursor ()
	Else
		SayLine ()
	EndIf
	Return
EndIf
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		JawsEnd ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript JawsEnd ()
EndScript

Script JawsPageUp ()
var
	int iVerbosity,
	int view,
	string sClass
If (! IsPcCursor ()) then
	PerformScript JawsPageUp ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript JawsPageUp ()
	Return
EndIf
let sClass = GetWindowClass (GetFocus ())
If (sClass == wcListBox) then
	PerformScript JawsPageUp ()
	Return
EndIf
let iVerbosity = GetVerbosity ()
If (GetWindowSubTypeCode (GetFocus ()) == wt_listbox) then
	{Page Up}
	If (DialogActive ()) then
		SayLine ()
		Return
	EndIf
	Pause ()
	If (iVerbosity > 0) then
		SayFromCursor ()
	Else
		SayLine ()
	EndIf
	Return 
EndIf
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		JawsPageUp ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript JawsPageUp ()
EndScript

Script JawsPageDown ()
var
	int iVerbosity,
	int view,
	string sClass
If (! IsPcCursor ()) then
	PerformScript JawsPageDown ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript JawsPageDown ()
	Return
EndIf
let sClass = GetWindowClass (GetFocus ())
If (sClass == wcListBox) then
	PerformScript JawsHome ()
	Return
EndIf
let iVerbosity = GetVerbosity ()
If (GetWindowSubTypeCode (GetFocus ()) == wt_listbox) then
	{Page Down}
	If (DialogActive ()) then
		SayLine ()
		Return
	EndIf
	Pause ()
	If (iVerbosity > 0) then
		SayFromCursor ()
	Else
		SayLine ()
	EndIf
	Return
EndIf
if IsPCCursor () then
	let view = CalendarView (GetCurrentWindow ()) 
	if view then
		JawsPageDown ()
		ReadDate (view)
		return
	EndIf
EndIf
PerformScript JawsPageDown ()
EndScript

String Function GetAppTitle ()
return GetWindowName (GetAppMainWindow (GetFocus ()))
EndFunction

Script CloseOfficeAssistant ()
var
	handle hWnd
SaveCursor()
JAWSCursor()
If (GetProgramVersion (GetAppFilePath ()) > 8) then
	let Hwnd = FindTopLevelWindow ("Agentanim", "")
Else
let hWnd = FindTopLevelWindow ("MSOAssistant", "")
EndIf
if (hWnd && IsWindowVisible (hWnd)) then
	MoveToWindow(hWnd)
  SpeechOff ()
  Pause ()		
	RightMouseButton ()
pause()
  Pause ()
	{h}
  SpeechOn ()
	RestoreCursor()
	Say(msg31, ot_message) ;"Office Assistant closed"
else
	Say(msg32, ot_message) ;"Office Assistant not found"
endif
EndScript

Void Function AutoSayHeader (int nID)
var
handle Hwnd
let Hwnd = FindDescendantWindow (GetTopLevelWindow (getFocus ()), nID)
If (Hwnd) then
  invisibleCursor ()
  MoveToWindow (Hwnd)
  SayWindow (Hwnd, read_everything)
EndIf
EndFunction


Script HotKeyHelp ()
var
string SWinName,
int IControlID
SayExtendedHelpHotKey ()
say(msg39+GetScriptKeyName ("CloseOfficeAssistant"), ot_help) ;Use Control + Insert + F4 to close the office assistant
Say(msg427+GetScriptKeyName ("CallToolBars"), ot_help) ;"Use insert + F8 to pop up the global key stroke dialog list"
  let SWinName = GetWindowname (GetRealWindow (GetFocus ()))
  let IControlID = GetControlID (GetFocus ())
If (SWinName == SpellingDialogName)  then
  Say(msg43 + GetScriptKeyName ("ReadMisspelledAndSuggestion"), ot_help) ;Use Insert + F7 to read the mis spelled word and suggestion
  Say(msg47+GetScriptKeyName ("WindowKeysHelp"), ot_help) ;Use Insert + W for the spell checker short cut keys
Return
endIf  
If (StringContains (sWinName, NoteDialogName)) then
	Say(msg36+GetScriptKeyName ("ClickNoteIcon"), ot_help) ;Use Control + Insert + T to click the Note Icon
	Return
EndIf
If (StringContains (sWinName, TaskDialogName)) then
	Say(msg37+GetScriptKeyName ("ClickReminderSoundButton"), ot_help) ;Use Alt + shift + 7 to click the Reminder Button
	Return
EndIf
If (StringContains (sWinName, CalendarTitleList)) then
	Say(msg41+GetScriptKeyName ("SayDate"), ot_help) ;Use Control + Insert + d to say the date
	Return
EndIf
Say(msg33+GetScriptKeyName ("AttachmentsList"), ot_help) ;Use Insert + A for the attachments list
say(msg34+GetScriptKeyName ("ClickAddressButton"), ot_help) ;Use Alt + Shift + 9 to click the AddressBook button
say(msg35+GetScriptKeyName ("ClickCcButton"), ot_help) ;Use Alt + Shift + 4 to click the CC Button
Say(msg38+GetScriptKeyName ("ClickToButton"), ot_help) ;Use Alt + shift + 3 to click the TO Button
say(msg40+GetScriptKeyName ("GoToBodyWindow"), ot_help) ;Use Alt + ` to go to the body window
say(msg42+GetScriptKeyName ("ScriptFileName"), ot_help) ;Use Insert + Q to read the script file name
EndScript

Script WindowKeysHelp ()
var
  string SWinName
  let SWinName = GetWindowName (GetRealWindow (GetFocus ()))
If (SWinName == SpellingDialogName) then
  Say(msg48, ot_help) ;Use Alt + I to ignore the word found
  Say(msg49, ot_help) ;Use Alt + G to ignore all ocurrances of word found
  Say(msg50, ot_help) ;Use Alt + C to change the word found
  say(msg51, ot_help) ;Use Alt + L to change all ocurrances of the word found
  Say(msg52, ot_help) ;Use Alt + A to Add the word found to the custom dictionary
  Say(msg53, ot_help) ;Use Alt + O to bring up the dictionary options for the spell checker
Return
EndIf
Say(msg54, ot_help) ;Use Shift + F1 to display the screen tips for Outlook 98
Say(msg55, ot_help) ;Use Control + Shift + D to Dial from Outlook 98
Say(msg56, ot_help) ;Use Control + shift + F to perform an advanced find
Say(msg57, ot_help) ;Use Control + shift + > to move to the next item
Say(msg58, ot_help) ;Use Control + shift + < to move to the previous item
Say(msg59, ot_help) ;Use Control + Q to mark an item as read
Say(msg60, ot_help) ;Use Control + r to reply to a message
Say(msg61, ot_help) ;Use Control + Shift + R to reply to all in a message
Say(msg62, ot_help) ;Use Control + F to forward a message
Say(msg63, ot_help) ;Use Shift + F3 to switch between upper and lower case
Say(msg64, ot_help) ;Use Control + Shift + Z to clear formatting
Say(msg65, ot_help) ;Use Control + Shift + A to create an appointment
Say(msg66, ot_help) ;Use Control + shift + C to create a contact
Say(msg67, ot_help) ;Use Control + Shift + E to create a new folder
Say(msg68, ot_help) ;Use Control + Shift + J to create a journal entry
Say(msg69, ot_help) ;Use Control + Shift + M to create a message
Say(msg70, ot_help) ;Use Control + Shift + N to create a note
Say(msg71, ot_help) ;Use Control + Shift + Q to create a meeting request
Say(msg72, ot_help) ;Use Control + Shift + P to find people
Say(msg73, ot_help) ;Use Control + Shift + K to create a task
Say(msg74, ot_help) ;Use Control + shift + U to create a task request
Say(msg75, ot_help) ;Use Control + Chift + H to create a new office document
Say(msg76, ot_help) ;Use F5 to receive Email messages
Say(msg77, ot_help) ;Use Control + shift + G to flag item for follow up
Say(msg78, ot_help) ;Use alt + S to save and close an item
Say(msg79, ot_help) ;Use Control + Y to go to a specific folder
Say(msg80, ot_help);Use Control + Shift + S to post item to a specific folder
Say(msg81, ot_help) ;Use Control + shift + Y to copy an item
Say(msg82, ot_help) ;Use Control + Shift + V to move an item to a specific folder
Say(msg83, ot_help) ;Use Control + Shift + B to open the address book
Say(msg84, ot_help) ;Use shift + F10 to display short cuts for Outlook 98
Say(msg85, ot_help);Use F4 to search for text
Say(msg86, ot_help) ;Use Shift + F4 to search for the next occurrance of text
Say(msg87, ot_help) ;Use Control + shift + I to move to the In Box from anywhere
EndScript

Void Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, buttonLabel, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msgLabelNotFound, ot_control_name)
EndIf
EndFunction

Int Function FindString (handle hwnd, string str, int direction, int restriction)
; overrides the built-in FindString to handle searching for labels in the toolbar.
var
	int c,
	int x,
	int y
if ((GetControlId (hwnd) == tool_bar) &&
	(GetWindowSubTypeCode (hwnd) == wt_toolbar) && restriction) then
; the search is restricted to the Outlook 98 toolbar, so search on your own!
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	RestrictCursor (off)
	while ((GetCurrentWindow () == hwnd) &&
		(c<20))
		if (GetWord () == str) then
			let x = GetCursorCol ()
			let y = GetCursorRow ()
			RestoreCursor ()
			JawsCursor ()
			MoveTo (x,y)
			return 1
		EndIf
		NextWord ()
		let c = c+1
	EndWhile
	return 0
else
	return FindString (hwnd, str, direction, restriction)
EndIf
EndFunction

HANDLE Function GetToolbar ()
var
	handle WinHandle
let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar)
if (winHandle && 
	GetWindowClass (winHandle) == wc_toolbar) then
	return winHandle
EndIf
return 0
EndFunction

Void Function ToolBar ()
var
	handle winHandle,
	int item
let winHandle = GetToolbar ()
let item = dlgSelectItemInList (strToolbar+strToolbar1+strToolbar2	, ToolbarDialogName, true)
let nSuppressEcho = true
delay (2)

if (item == Back) then
PerformScript MoveBackItem()
elif (item == Forward) then
PerformScript MoveForwardItem()
Elif (Item == MailMessage) then
{Control + shift + M}
ElIf (Item == PrintDoc) then
{Control + P}
elIf (Item == MoveToFolder) then
{Control + Shift + V}
ElIf (Item == DeleteItem) then
{Control + D}
Elif (Item == Reply) then 
{Control + R}
Elif (Item == ReplyToAll) then 
{Control + Shift + R}
elIf (Item == ForwardMessage) then
{Control + F}
ElIf (Item == AddressBook) then
{control + Shift + B}
ElIf (Item == Dial) then
{Control + shift + D}
elif (Item == AdvancedFind) then
{control + shift + F}
ElIf (Item == MarkAsRead) then 
{Control + Q}
ElIf (Item == ClearFormatting) then
{Control + Shift + Z}
ElIf (Item == appointmentChoice) then
{control + Shift + A}
Elif (Item == contact) then
{Control + Shift + C}
ElIf (Item == NewFolder) then
{control + Shift + E}
Elif (Item == Journal) then
{Control + Shift + J}
ElIf (Item == Note) then 
{Control + Shift + N}
ElIf (Item == MeetingRequest) then
{Control + Shift + Q}
elIf (Item == FindPeople) then
{Control + shift + P}
ElIf (Item == Task) then
{control + shift + K} 
ElIf (Item == TaskRequest) then
{Control + Shift + U}
ElIf (Item == OfficeDocument) then
{Control + shift + H}
ElIf (Item == Flag) then
{Control + Shift + G}
ElIf (Item == Post) then 
{Control + shift + S}
ElIf (Item == CopyItem) then
{Control + Shift +Y}
ElIf (Item == InBox) then
Pause ()
{Control + Shift + I}
ElIf (Item == GoToFolder) then
{Control + Y}
endIf
let nSuppressEcho = false
EndFunction

Int Function IsToolbarList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == ToolbarDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Script CallToolBars ()
ToolBar ()
EndScript

Script MoveBackItem ()
{Control + Shift + ,}
Pause ()
If (CaretVisible () && GetWindowSubTypeCode (GetFocus ()) == 43) then
AutoSayHeader (from_prompt)
AutoSayHeader (from_field)
Delay (2)
AutoSayHeader (subject_prompt)
AutoSayHeader (subject_field)
Delay (2)
PcCursor ()
SayLine ()
Return 
EndIf
EndScript

Script MoveForwardItem ()
{Control + Shift + .}
Pause ()
If (CaretVisible () && GetWindowSubTypeCode (GetFocus ()) == 43) then
AutoSayHeader (from_prompt)
AutoSayHeader (from_field)
Delay (2)
AutoSayHeader (subject_prompt)
AutoSayHeader (subject_field)
Delay (2)
PcCursor ()
SayLine  ()
Return 
EndIf
EndScript
	
Script ReadCurrentScreen ()
If (IsVirtualPcCursor ()) then ; doesn't work
	Say (msg461, OT_MESSAGE); "not available in virtual PC cursor mode"
	Return
EndIf
MoveToWindow (GetFocus ())
RestrictCursor (On)
SayWindow (GetFocus (), read_everything)
RestrictCursor (Off)
EndScript

Script ReadNextScreen ()
let nSuppressEcho = true
PcCursor ()
JawsPageDown ()
Delay (2)
let nSuppressEcho = false
PerformScript ReadCurrentScreen()
EndScript

Script ReadPriorScreen ()
let nSuppressEcho = true
PcCursor ()
JawsPageUp()
Delay (2)
let nSuppressEcho = false
PerformScript ReadCurrentScreen()
EndScript

Script SayLine ()
var 
  string SWinName,
  int IControlID
  let SWinName = GetWindowName (GetRealWindow (GetFocus ()))
  let IControlID = GetControlID (GetFocus ())

If (StringContains (SWinName, msg455) && IControlID == 4363) then
  PerformScript SayLine ()
  Return
EndIf
If (StringContains (SWinName, ContactDialogName) && IControlID == message_field) then
  Say(msg2, ot_control_name) ;"edit"
  SayLine ()
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID ==con_phone_descript_one
|| IControlID == con_phone_descript_two || IControlID == con_phone_descript_three
|| IControlID == con_phone_descript_four) then
  Say(msg90, ot_message) ;"Phone Number Description Button"
  Return
elIf (StringContains (SWinName, ContactDialogName) && IControlID == address_field) then
  Say(msg94, ot_message) ;"Address:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_address) then
  Say(msg91, ot_message) ;"Enter multiple address button"
  Return  
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_email) then
  Say(msg92, ot_message) ;"Enter multiple email adresses button"
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == email_field) then
  Say(msg95, ot_message) ;"email address:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
EndIf
If (StringContains (SWinName, TaskDialogName) && IControlID == message_field) then
  Say(msg2, ot_control_name) ;"edit"
  SayLine ()
  Return 
EndIf
If (StringContains (SWinName, JournalDialogName) && IControlID == j_startdate) then
  Say(msg88, ot_message) ;"Start Date:"
  Say(msg2, ot_control_name) ;"edit"
  sayWindow (GetFocus (), read_everything)
  Return
ElIf (StringContains (SWinName, JournalDialogName)  && IControlID == message_field) then 
  Say(msg2, ot_control_name) ;"edit"
  SayLine ()
  Return
EndIf
If (StringContains (SWinName, MeetingDialogName) && IControlID == app_startdate) then
  Say(msg88, ot_message) ;"Start Date:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
  Return
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == app_enddate) then
  Say(msg89, ot_message) ;"End Date:"
  Say(msg2, ot_control_name) ;"edit"  
SayWindow (GetFocus  (), read_everything)
  Return
ElIf (StringContains (SWinName, MeetingDialogName) && IControlID == message_field) then
  Say(msg2, ot_control_name) ;"edit"
  SayLine () 
  Return
EndIf
If (StringContains (SWinName, AppointmentDialogName) && IControlID == app_startdate) then
  Say(msg88, ot_message) ;"Start Date:"
  Say(msg2, ot_control_name) ;"edit"
  SayWindow (GetFocus (), read_everything)
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == app_enddate) then
  Say(msg89, ot_message) ;"End Date:"
  Say(msg2, ot_control_name) ;"edit"  
SayWindow (GetFocus  (), read_everything)
ElIf (StringContains (SWinName, AppointmentDialogName) && IControlID == message_field) then
  Say(msg2, ot_control_name) ;"edit"
  SayLine () 
endIf
PerformScript SayLine()
EndScript

Script SayWord ()
var
  string SWinName,
  int IControlID
  let SWinName = GetWindowName (GetRealWindow (GetFocus ()))
  let IControlID = GetControlID (GetFocus ())
If (IsSameScript ()) Then
	SpellWord()
	AddHook (HK_SCRIPT, "SpellWordHook")
Return
EndIf
If (StringContains (SWinName, msg455) && IControlID == 4363) then
  PerformScript SayWord ()
  Return
EndIf
If (StringContains (SWinName, ContactDialogName) && IControlID == con_phone_descript_one
|| IControlID == con_phone_descript_two || IControlID == con_phone_descript_three 
||  IControlID == con_phone_descript_four) then
  Say(msg90, ot_message) ;"Phone Number Description Button"
  Return
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_address) then
  Say(msg91, ot_message) ;"enter multiple address button"
  Return 
ElIf (StringContains (SWinName, ContactDialogName) && IControlID == con_email) then
  Say(msg92, ot_message) ;"enter multiple email addresses button"
  Return
Else
	let globalSayingCurrentItem = 1
	SayWord()
	let globalSayingCurrentItem = 0
EndIf
EndScript

Script SaySelectedLink ()
If (CaretVisible () && GetWindowSubTypeCode (GetFocus ()) == 43) then 
Return
endIf
SayFocusedObject ()
EndScript

Script MessageBodyDelete ()
var
string SWinName
let SWinName = GetWindowName (GetRealWindow (GetFocus ()))
{Control + D}
Pause ()
StopSpeech ()
Pause ()
If (CaretVisible () && GetWindowSubTypeCode (GetFocus ()) == 43) then
AutoSayHeader (from_prompt)
AutoSayHeader (from_field)
Delay (2)
AutoSayHeader (subject_prompt)
AutoSayHeader (subject_field)
Delay (2)
PcCursor ()
SayLine ()
Return 
EndIf
If (GetWindowSubTypeCode (GetFocus ()) == wt_listbox) then
  SayLine ()
  Return 
EndIf
EndScript

Script ControlBackSpace ()
InvisibleCursor ()
RouteInvisibleToPc ()
PriorWord ()
SayWord ()
PcCursor ()
{Control + Back Space}
EndScript




Script NewOfficeDocument ()
	{Control + Shift + H}
EndScript

Script NewContactDialog ()
	{Control + Shift + C}
EndScript

Void Function SayAllStoppedEvent ()
  Return
EndFunction

Script SayDefaultButton ()
var 
  string DefaultButtonName
If (Dialogactive ()) then
  let DefaultButtonName = GetDefaultButtonName ()
If (DefaultButtonName != "") then
If (GetVerbosity () == beginner) then
;  Say (msg435, ot_message)
EndIf
  Say (msg434, ot_message)
Else
  Say (msg434, ot_help)
EndIf
Else
  Say (msg436, ot_message)
EndIf  
EndScript

Script ControlUpArrow ()
var
	int TheTypeCode,
	int MenuMode
Let MenuMode =  GlobalMenuMode
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
if IsJAWSCursor ()
 then PerformScript SayPriorParagraph()
return
endif
if DialogActive () ||
 ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == 	WT_EDITCOMBO) ||   
(TheTypeCode == WT_Listbox) ||
   (TheTypeCode == WT_LISTVIEW) ||
(TheTypeCode == WT_Combobox) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX))||
GetWindowClass (GetcurrentWindow ()) == wc_Custom||
 GetWindowClass (GetCurrentWindow ())==wc_toolbar
 then
SpeechOff()
     {control + up arrow} ; move without removing selection
     pause ()
SpeechOn ()
If (GetColorText () == msgWhite) then
  Say (msg445, ot_message)
Else
  Say (msg446, ot_message)
EndIf
     SayLine()
     return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
  SayWord()
  return
endif
if (MenuMode > 0) then return
 EndIf
PerformScript SayPriorParagraph()
EndScript

Script ControlDownArrow ()
var
	int MenuMode,
	int TheTypeCode
Let MenuMode =  GlobalMenuMode
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
if IsJAWSCursor ()
 then PerformScript SayNextParagraph()
return
endif
if  DialogActive () || 
 ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_LISTVIEW) ||
   (TheTypeCode == 	WT_EDITCOMBO) ||   
   (TheTypeCode == WT_Listbox) ||
   (TheTypeCode == WT_Combobox) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) ||
GetWindowClass (GetcurrentWindow ()) == wc_Custom ||
GetWindowClass (GetCurrentWindow ())==wc_toolbar 
 then   
SpeechOff ()
{control + down arrow} ; move without removing selection
     pause ()
SpeechOn ()
If (GetColorText () == msgWhite) then
  Say (msg445, ot_message)
Else
  Say (msg446, ot_message)
endIf
     SayLine()
     return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
  {control + down arrow}
  SayWord()
  return
endif
if (MenuMode > 0) then {control + down arrow} 
return 
EndIf
 PerformScript SayNextParagraph()
		EndScript

Script ReadWarningHeader ()
AutoSayHeader (4515)
AutoSayHeader (4100)
Delay (1)
AutoSayHeader (4516)
AutoSayHeader (4101)
Delay (1)
AutoSayHeader (4517)
AutoSayHeader (4102)
  AutoSayHeader (4096)
PcCursor ()
EndScript

Script JawsDelete ()
If (GetWindowSubTypeCode (GetFocus ()) == wt_listbox) then
  {Delete}
	ScheduleFunction ("SayLine", 5)
  Return
EndIf
  PerformScript JawsDelete ()
EndScript

Script SelectAll ()
var
	int iWinType,
	handle hWnd
SelectEntireDocument()
let hWnd = GetCurrentWindow ()
let iWinType = GetWindowTypeCode (hWnd)
; since list boxes are so customized here ...
If (iWinType == WT_LISTBOX) then
	SayWindow (hWnd, Read_Highlighted)
EndIf
EndScript

